/*
 * Decompiled with CFR 0.152.
 */
package beans;

import beans.AgendaEvent;
import beans.AgendaNewEvent;
import beans.AgendaUser;
import beans.AgendaWeek;
import beans.MyDropTargetListImp;
import beans.TimeHourMinute;
import business.EventUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.dnd.DropTarget;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.Locale;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import tables.EbEvents;
import tables.EbReleventempdate;

public class AgendaDay
extends JPanel {
    private Calendar endOfDay;
    private Calendar debutOfDay;
    private AgendaWeek parentWeek;
    private List<AgendaEvent> eventList;
    private JLabel dayNumber;
    private AgendaUser user;
    private boolean isToday;
    private JButton btAddEvent;
    private JButton btMore;
    private JPanel contentPane;

    public AgendaDay(AgendaWeek parent, Calendar dateOfDay, AgendaUser user) {
        this.parentWeek = parent;
        this.user = user;
        DropTarget dropTarget = new DropTarget(this, 2, new MyDropTargetListImp(this), true, null);
        this.setDropTarget(dropTarget);
        this.setPreferredSize(new Dimension(64, 156));
        this.setLayout(new GridBagLayout());
        this.eventList = new ArrayList<AgendaEvent>();
        this.contentPane = new JPanel();
        this.contentPane.setLayout(new GridBagLayout());
        this.debutOfDay = Calendar.getInstance(Locale.FRANCE);
        this.debutOfDay.setTimeInMillis(dateOfDay.getTimeInMillis());
        this.debutOfDay.set(11, 0);
        this.debutOfDay.set(12, 0);
        this.debutOfDay.add(12, -1);
        this.endOfDay = dateOfDay;
        this.endOfDay.set(11, 23);
        this.endOfDay.set(12, 59);
        if (this.endOfDay.get(6) == Calendar.getInstance(Locale.FRANCE).get(6) && this.endOfDay.get(3) == Calendar.getInstance(Locale.FRANCE).get(3) && this.endOfDay.get(1) == Calendar.getInstance(Locale.FRANCE).get(1)) {
            this.setBorder(BorderFactory.createLineBorder(new Color(0, 51, 51), 2));
        } else {
            this.setBorder(BorderFactory.createEtchedBorder());
        }
        if (this.endOfDay.get(3) == Calendar.getInstance(Locale.FRANCE).get(3) && this.endOfDay.get(1) == Calendar.getInstance(Locale.FRANCE).get(1)) {
            this.setBackground(new Color(50, 150, 230));
        }
        this.btAddEvent = new JButton("new");
        this.btAddEvent.setMargin(new Insets(1, 13, 1, 13));
        this.btAddEvent.setContentAreaFilled(false);
        this.btAddEvent.setBackground(this.getBackground());
        this.btAddEvent.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                AgendaDay.this.addEvent();
            }
        });
        this.contentPane.setBackground(this.getBackground());
        this.dayNumber = new JLabel(dateOfDay.get(5) + " " + dateOfDay.getDisplayName(2, 2, Locale.FRENCH));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 23;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        this.add((Component)this.dayNumber, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 23;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 2;
        this.add((Component)this.contentPane, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 23;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        this.add((Component)this.btAddEvent, gridBagConstraints);
        this.setBackground(this.parentWeek.getColor());
        this.setBackground(this.parentWeek.getColor());
    }

    public AgendaDay(AgendaWeek parent, Calendar dateOfDay, List<EbEvents> list, AgendaUser user) {
        this.user = user;
        this.parentWeek = parent;
        DropTarget dropTarget = new DropTarget(this, 2, new MyDropTargetListImp(this), true, null);
        this.setDropTarget(dropTarget);
        this.setLayout(new GridBagLayout());
        this.eventList = new ArrayList<AgendaEvent>();
        this.contentPane = new JPanel();
        this.contentPane.setLayout(new GridBagLayout());
        this.debutOfDay = Calendar.getInstance(Locale.FRANCE);
        this.debutOfDay.setTimeInMillis(dateOfDay.getTimeInMillis());
        this.debutOfDay.set(11, 0);
        this.debutOfDay.set(12, 0);
        this.debutOfDay.add(12, -1);
        this.endOfDay = dateOfDay;
        this.endOfDay.set(11, 23);
        this.endOfDay.set(12, 59);
        if (this.endOfDay.get(6) == Calendar.getInstance(Locale.FRANCE).get(6) && this.endOfDay.get(3) == Calendar.getInstance(Locale.FRANCE).get(3) && this.endOfDay.get(1) == Calendar.getInstance(Locale.FRANCE).get(1)) {
            this.setBorder(BorderFactory.createLineBorder(new Color(0, 51, 51), 2));
        } else {
            this.setBorder(BorderFactory.createEtchedBorder());
        }
        if (this.endOfDay.get(3) == Calendar.getInstance(Locale.FRANCE).get(3) && this.endOfDay.get(1) == Calendar.getInstance(Locale.FRANCE).get(1)) {
            this.setBackground(new Color(50, 150, 230));
        }
        this.btAddEvent = new JButton("new");
        this.btAddEvent.setMargin(new Insets(1, 13, 1, 13));
        this.btAddEvent.setContentAreaFilled(false);
        this.btAddEvent.setBackground(this.getBackground());
        this.btAddEvent.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                AgendaDay.this.addEvent();
            }
        });
        this.contentPane.setBackground(this.getBackground());
        this.dayNumber = new JLabel(dateOfDay.get(5) + " " + dateOfDay.getDisplayName(2, 2, Locale.FRENCH));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 23;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        this.add((Component)this.dayNumber, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 23;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 2;
        this.add((Component)this.contentPane, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 23;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        this.add((Component)this.btAddEvent, gridBagConstraints);
        this.setBackground(this.parentWeek.getColor());
        this.addFromList(list);
        if (this.eventList.isEmpty()) {
            this.setPreferredSize(new Dimension(64, 156));
        }
        this.displayEvents();
    }

    public void reloadDay(List<EbEvents> list) {
        this.eventList.clear();
        this.contentPane.revalidate();
        this.addFromList(list);
        if (this.eventList.isEmpty()) {
            this.setPreferredSize(new Dimension(64, 156));
        }
        this.displayEvents();
    }

    public AgendaUser getUser() {
        return this.user;
    }

    private void addFromList(List<EbEvents> list) {
        for (EbEvents ee : list) {
            List<EbReleventempdate> eventDate;
            Calendar from = Calendar.getInstance(Locale.FRANCE);
            from.setTime(ee.getEbEventsStartDate());
            Calendar to = Calendar.getInstance(Locale.FRANCE);
            to.setTime(ee.getEbEventsEndDate());
            if (!this.debutOfDay.before(to) || !this.endOfDay.after(from) || (eventDate = EventUtil.getEventUser(ee.getIdebEvent(), this.user.getId())).size() <= 0) continue;
            for (EbReleventempdate eventEmpDate : eventDate) {
                Calendar eventCalendar = Calendar.getInstance(Locale.FRANCE);
                eventCalendar.setTime(eventEmpDate.getEbRelEventEmpDateStart());
                if (eventCalendar.get(6) != this.endOfDay.get(6)) continue;
                Calendar cal1 = Calendar.getInstance(Locale.FRANCE);
                Calendar cal2 = Calendar.getInstance(Locale.FRANCE);
                cal1.setTime(eventEmpDate.getEbRelEventEmpDateStart());
                cal2.setTime(eventEmpDate.getEbRelEventEmpDateEnd());
                this.eventList.add(new AgendaEvent(this, ee.getEbEventsName(), eventEmpDate.getIdebRelEventEmpDate(), cal1, cal2, eventEmpDate.isEbRelEventEmpDateFullDay()));
            }
        }
    }

    public JPanel getContentPane() {
        return this.contentPane;
    }

    public List<AgendaEvent> getEventList() {
        return this.eventList;
    }

    public JButton getBtMore() {
        return this.btMore;
    }

    private void showMore() {
        JPanel eventListPanel = new JPanel();
        eventListPanel.setLayout(new GridLayout(0, 4));
        for (AgendaEvent e : this.eventList) {
            eventListPanel.add(new AgendaEvent(e));
        }
        Object[] panelTab = new Object[]{eventListPanel};
        JOptionPane pane = new JOptionPane();
        pane.setOptions(panelTab);
        pane.setMessage("Ev\u00e8nements");
        pane.setOptionType(2);
        JDialog dialog = pane.createDialog(this, "");
        dialog.setModal(false);
        dialog.setVisible(true);
    }

    private void addEvent() {
        AgendaNewEvent ane;
        JFrame newEventFrame = new JFrame("Nouvel \u00e9v\u00e8nement");
        if (this.eventList.size() > 0) {
            ane = new AgendaNewEvent(this.eventList.get(this.eventList.size() - 1).getEnd(), newEventFrame);
        } else {
            Calendar today = Calendar.getInstance(Locale.FRANCE);
            today.setTime(this.endOfDay.getTime());
            today.set(11, 9);
            today.set(12, 0);
            ane = new AgendaNewEvent(today, newEventFrame);
        }
        newEventFrame.setDefaultCloseOperation(2);
        newEventFrame.add(ane);
        newEventFrame.pack();
        newEventFrame.setVisible(true);
    }

    public void displayEvents() {
        this.contentPane.removeAll();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 2;
        for (AgendaEvent ae : this.eventList) {
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 1.0;
            gridBagConstraints.fill = 2;
            this.contentPane.add((Component)ae, gridBagConstraints);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.fill = 2;
            this.contentPane.add((Component)new JSeparator(), gridBagConstraints);
        }
        this.revalidate();
    }

    public TimeHourMinute computeWorkTime() {
        long additionOfMillis = 0L;
        int hour = 0;
        int minute = 0;
        for (AgendaEvent ae : this.eventList) {
            if (ae.isIsWholeDayEvent()) continue;
            Calendar cal = Calendar.getInstance(Locale.FRANCE);
            cal.setTime(ae.getEnd().getTime());
            if (ae.getEnd().get(11) == 23 && ae.getEnd().get(12) == 59) {
                cal.add(12, 1);
            }
            long millis = cal.getTimeInMillis() - ae.getStart().getTimeInMillis();
            additionOfMillis += millis;
        }
        hour = (int)(additionOfMillis /= 60000L) / 60;
        minute = (int)additionOfMillis % 60;
        TimeHourMinute thm = new TimeHourMinute(hour, minute);
        if (hour > 0 || minute > 0) {
            // empty if block
        }
        return thm;
    }

    public String getDayNumber() {
        return this.dayNumber.getText();
    }

    public Calendar getDateOfDay() {
        return this.endOfDay;
    }

    public void dropAgendaEvent(AgendaEvent ae) {
        System.out.println("hash from new day " + this.hashCode());
        System.out.println("hash from new " + this.eventList.hashCode());
        this.eventList.add(new AgendaEvent(ae));
        System.out.println("item dropped onto " + this.getDayNumber());
        System.out.println("============================================");
        this.displayEvents();
    }

    public void dragAgendaEvent(AgendaEvent ae) {
        System.out.println("hash from old day " + this.hashCode());
        System.out.println("hash from old " + this.eventList.hashCode());
        System.out.println(this.eventList.indexOf(ae));
        this.eventList.remove(ae);
        System.out.println("item dragged from " + this.getDayNumber());
        System.out.println("============================================");
        this.displayEvents();
    }
}

