/*
 * Decompiled with CFR 0.152.
 */
package beans;

import beans.AgendaDay;
import beans.AgendaModEventDay;
import beans.DragGestureListImp;
import business.EventUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.dnd.DragSource;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Calendar;
import java.util.Locale;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import tables.EbReleventempdate;

public class AgendaEvent
extends JButton {
    private AgendaDay parentDay;
    private Calendar dateOfEvent;
    private String summary;
    private String description;
    private JLabel title;
    private JCheckBox userValid;
    private JCheckBox adminValid;
    private Calendar start;
    private Calendar end;
    private int id;
    private EbReleventempdate eventDate;
    private boolean isWholeDayEvent;

    public AgendaEvent() {
        this.summary = "dummy";
        this.title = new JLabel(this.summary);
        this.add(this.title);
    }

    public AgendaEvent(AgendaDay parent, String summary) {
        this.summary = summary;
        this.parentDay = parent;
        this.dateOfEvent = parent.getDateOfDay();
        this.id = this.hashCode();
        this.title = new JLabel(this.dateOfEvent.get(5) + " " + this.summary);
        this.setBackground(this.parentDay.getBackground());
        this.add(this.title);
        DragSource ds = new DragSource();
        ds.createDefaultDragGestureRecognizer(this, 2, new DragGestureListImp());
        this.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JOptionPane.showMessageDialog(AgendaEvent.this, AgendaEvent.this.summary + " " + AgendaEvent.this.id);
            }
        });
    }

    public AgendaEvent(AgendaDay parent, String summary, int id, Calendar start, Calendar end, boolean isFullDay) {
        String unbold;
        String bold;
        this.summary = summary;
        this.parentDay = parent;
        this.dateOfEvent = parent.getDateOfDay();
        this.id = id;
        this.start = Calendar.getInstance(Locale.FRANCE);
        this.end = Calendar.getInstance(Locale.FRANCE);
        this.start.setTime(start.getTime());
        this.end.setTime(end.getTime());
        this.userValid = new JCheckBox("Valider Temps");
        this.adminValid = new JCheckBox("Verrouiller Temps");
        this.userValid.setContentAreaFilled(false);
        this.isWholeDayEvent = isFullDay;
        this.eventDate = EventUtil.getEventUser(this.id);
        this.setOpaque(false);
        this.setLayout(new BorderLayout());
        if (this.isWholeDayEvent) {
            bold = "<b>";
            unbold = "</b>";
        } else {
            bold = "";
            unbold = "";
        }
        this.title = new JLabel("<html><body>" + bold + this.dateOfEvent.get(5) + " " + this.summary + "<br>from " + this.start.get(11) + ":" + this.start.get(12) + "<br> to " + this.end.get(11) + ":" + this.end.get(12) + unbold + "</body></html>");
        this.setContentAreaFilled(false);
        this.setOpaque(true);
        this.setBackground(this.parentDay.getBackground());
        this.add((Component)this.title, "Center");
        this.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AgendaEvent.this.displayEventDetail();
            }
        });
        this.setToolTipText(this.eventDate.getEbRelEventEmpDateJobDesc());
    }

    private void displayEventDetail() {
        JFrame eventFrame = new JFrame("D\u00e9tail \u00e9v\u00e8nement");
        eventFrame.setDefaultCloseOperation(2);
        AgendaModEventDay modEventPanel = new AgendaModEventDay(eventFrame, this.eventDate);
        eventFrame.add(modEventPanel);
        eventFrame.pack();
        eventFrame.setVisible(true);
    }

    public AgendaEvent(AgendaEvent a) {
        this.dateOfEvent = Calendar.getInstance(Locale.FRANCE);
        this.dateOfEvent.setTimeInMillis(a.dateOfEvent.getTimeInMillis());
        if (a.description != null) {
            this.description = String.copyValueOf(a.description.toCharArray());
        }
        this.id = a.id;
        this.start = a.start;
        this.end = a.end;
        this.isWholeDayEvent = a.isWholeDayEvent;
        this.parentDay = a.parentDay;
        this.summary = String.copyValueOf(a.summary.toCharArray());
        this.title = new JLabel(a.title.getText());
        this.eventDate = a.eventDate;
        this.setContentAreaFilled(false);
        this.setBackground(this.parentDay.getBackground());
        this.add(this.title);
        this.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AgendaEvent.this.displayEventDetail();
            }
        });
        this.setToolTipText(this.eventDate.getEbRelEventEmpDateJobDesc());
    }

    public String getSummary() {
        return this.summary;
    }

    public AgendaDay getParentDay() {
        return this.parentDay;
    }

    public void setParentDay(AgendaDay parentDay) {
        this.parentDay = parentDay;
    }

    public Calendar getStart() {
        return this.start;
    }

    public void setStart(Calendar start) {
        this.start = start;
    }

    public Calendar getEnd() {
        return this.end;
    }

    public void setEnd(Calendar end) {
        this.end = end;
    }

    public boolean isIsWholeDayEvent() {
        return this.isWholeDayEvent;
    }

    @Override
    public String toString() {
        return this.summary;
    }
}

