/*
 * Decompiled with CFR 0.152.
 */
package beans;

import beans.DateTimeBean;
import business.EventUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.Locale;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import tables.EbCli;
import tables.EbReleventempdate;
import tables.Employees;
import ui.TestApplet;

public class AgendaModEventDay
extends JPanel {
    private List<EbCli> cliList;
    private List<JCheckBox> userCheckBoxes;
    private EbReleventempdate event;
    private JFrame parent;
    private Calendar start;
    private Calendar end;
    private JButton btCancel;
    private JButton btDelete;
    private JButton btMod;
    private JPanel btPanel;
    private JPanel cancelBtPanel;
    private JCheckBox ckAllDays;
    private JCheckBox ckAllUsers;
    private JCheckBox ckAllUsersDate;
    private JCheckBox ckChgDH;
    private JCheckBox ckModDate;
    private JPanel cliPanel;
    private JPanel contentPanel;
    private JPanel datesPanel;
    private JPanel debutPanel;
    private JPanel deleteBtPanel;
    private JPanel descPanel;
    private DateTimeBean endTimeBean;
    private JPanel finPanel;
    private JComboBox jCBoxCli;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JPanel modBtPanel;
    private DateTimeBean startTimeBean;
    private JPanel titlePanel;
    private JTextArea txtGeneralDesc;
    private JTextArea txtTaskDesc;
    private JTextField txtTitle;
    private JPanel userPanel;

    public AgendaModEventDay() {
        this.initComponents();
    }

    public AgendaModEventDay(JFrame parent, EbReleventempdate event) {
        this.initComponents();
        this.start = Calendar.getInstance(Locale.FRANCE);
        this.end = Calendar.getInstance(Locale.FRANCE);
        this.start.setTime(event.getEbRelEventEmpDateStart());
        this.end.setTime(event.getEbRelEventEmpDateEnd());
        this.event = event;
        this.parent = parent;
        this.userCheckBoxes = new ArrayList<JCheckBox>();
        this.cliList = new ArrayList<EbCli>();
        this.populateUsers();
        this.txtTitle.setText(this.event.getEbEvents().getEbEventsName());
        this.txtGeneralDesc.setText(event.getEbEvents().getEbEventsDesc());
        this.txtTaskDesc.setText(event.getEbRelEventEmpDateJobDesc());
        this.startTimeBean.setDateTime(this.start);
        this.endTimeBean.setDateTime(this.end);
        this.startTimeBean.setDateEnabled(false);
        this.endTimeBean.setDateEnabled(false);
        this.parent.setAlwaysOnTop(true);
        if (event.isEbRelEventEmpDateFullDay()) {
            this.ckChgDH.setText("\u00c9v\u00e8nement journ\u00e9e enti\u00e8re, veuillez confirmer les heures");
        }
        this.ckChgDH.setSelected(!event.isEbRelEventEmpDateFullDay());
        this.ckChgDHActionPerformed(null);
    }

    private Object[] populateClients() {
        this.cliList = EventUtil.getClients();
        return this.cliList.toArray();
    }

    private void populateUsers() {
        for (Employees emp : TestApplet.empList) {
            JCheckBox ckb = new JCheckBox();
            ckb.setText(emp.getInitiales());
            this.userCheckBoxes.add(ckb);
        }
        System.out.println("populating users");
        for (JCheckBox ckb : this.userCheckBoxes) {
            this.userPanel.add(ckb);
        }
        this.setEmployees();
        this.revalidate();
    }

    public Employees[] getEmployees() {
        ArrayList<Employees> participants = new ArrayList<Employees>();
        for (Component o : this.userPanel.getComponents()) {
            if (!(o instanceof JCheckBox)) continue;
            JCheckBox ckb = (JCheckBox)o;
            String initiales = ckb.getText();
            if (!ckb.isSelected() || !TestApplet.empMap.containsKey(initiales)) continue;
            Employees emp = TestApplet.empMap.get(initiales);
            participants.add(emp);
        }
        System.out.println(participants.size() + " participants");
        return participants.toArray(new Employees[0]);
    }

    public void setEmployees() {
        List<Employees> participants = EventUtil.getOtherParticipants(this.event.getEbEvents().getIdebEvent(), this.event.getEbRelEventEmpDateDate());
        System.out.println(participants.size());
        for (Component o : this.userPanel.getComponents()) {
            if (!(o instanceof JCheckBox)) continue;
            JCheckBox ckb = (JCheckBox)o;
            String initiales = ckb.getText();
            for (Employees emp : participants) {
                if (!initiales.equals(emp.getInitiales())) continue;
                ckb.setSelected(true);
            }
        }
    }

    private void initComponents() {
        this.contentPanel = new JPanel();
        this.titlePanel = new JPanel();
        this.txtTitle = new JTextField();
        this.ckChgDH = new JCheckBox();
        this.datesPanel = new JPanel();
        this.debutPanel = new JPanel();
        this.startTimeBean = new DateTimeBean();
        this.finPanel = new JPanel();
        this.endTimeBean = new DateTimeBean();
        this.ckModDate = new JCheckBox();
        this.ckAllUsersDate = new JCheckBox();
        this.userPanel = new JPanel();
        this.cliPanel = new JPanel();
        this.jCBoxCli = new JComboBox();
        this.descPanel = new JPanel();
        this.jLabel1 = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.txtGeneralDesc = new JTextArea();
        this.jLabel2 = new JLabel();
        this.jScrollPane2 = new JScrollPane();
        this.txtTaskDesc = new JTextArea();
        this.btPanel = new JPanel();
        this.modBtPanel = new JPanel();
        this.btMod = new JButton();
        this.cancelBtPanel = new JPanel();
        this.btCancel = new JButton();
        this.deleteBtPanel = new JPanel();
        this.ckAllUsers = new JCheckBox();
        this.ckAllDays = new JCheckBox();
        this.btDelete = new JButton();
        this.setLayout(new BorderLayout());
        this.contentPanel.setLayout(new GridBagLayout());
        this.titlePanel.setBorder(BorderFactory.createTitledBorder("Nom de l'\u00e9v\u00e8nement"));
        this.titlePanel.setLayout(new BoxLayout(this.titlePanel, 2));
        this.titlePanel.add(this.txtTitle);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        this.contentPanel.add((Component)this.titlePanel, gridBagConstraints);
        this.ckChgDH.setText("D\u00e9cocher pour transformer en \u00e9v\u00e8nement journ\u00e9e enti\u00e8re (heures non d\u00e9finies)");
        this.ckChgDH.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AgendaModEventDay.this.ckChgDHActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        this.contentPanel.add((Component)this.ckChgDH, gridBagConstraints);
        this.datesPanel.setBorder(BorderFactory.createTitledBorder("Dates"));
        this.debutPanel.setBorder(BorderFactory.createTitledBorder("D\u00e9but"));
        this.debutPanel.add(this.startTimeBean);
        this.datesPanel.add(this.debutPanel);
        this.finPanel.setBorder(BorderFactory.createTitledBorder("Fin"));
        this.finPanel.add(this.endTimeBean);
        this.datesPanel.add(this.finPanel);
        this.ckModDate.setText("Modifier dates globales");
        this.ckModDate.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AgendaModEventDay.this.ckModDateActionPerformed(evt);
            }
        });
        this.datesPanel.add(this.ckModDate);
        this.ckAllUsersDate.setText("Pour tout le monde");
        this.datesPanel.add(this.ckAllUsersDate);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        this.contentPanel.add((Component)this.datesPanel, gridBagConstraints);
        this.userPanel.setBorder(BorderFactory.createTitledBorder("Participants"));
        this.userPanel.setLayout(new GridLayout(0, 6));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        this.contentPanel.add((Component)this.userPanel, gridBagConstraints);
        this.cliPanel.setBorder(BorderFactory.createTitledBorder("Client"));
        this.cliPanel.setLayout(new BoxLayout(this.cliPanel, 2));
        this.jCBoxCli.setModel(new DefaultComboBoxModel<Object>(this.populateClients()));
        this.cliPanel.add(this.jCBoxCli);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        this.contentPanel.add((Component)this.cliPanel, gridBagConstraints);
        this.descPanel.setBorder(BorderFactory.createTitledBorder("Description"));
        this.descPanel.setLayout(new GridBagLayout());
        this.jLabel1.setText("Description G\u00e9n\u00e9rale");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        this.descPanel.add((Component)this.jLabel1, gridBagConstraints);
        this.txtGeneralDesc.setBackground(new Color(204, 204, 204));
        this.txtGeneralDesc.setColumns(20);
        this.txtGeneralDesc.setRows(5);
        this.jScrollPane1.setViewportView(this.txtGeneralDesc);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 19;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(10, 10, 10, 10);
        this.descPanel.add((Component)this.jScrollPane1, gridBagConstraints);
        this.jLabel2.setText("Description T\u00e2che");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        this.descPanel.add((Component)this.jLabel2, gridBagConstraints);
        this.txtTaskDesc.setColumns(20);
        this.txtTaskDesc.setRows(5);
        this.jScrollPane2.setViewportView(this.txtTaskDesc);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(10, 10, 10, 10);
        this.descPanel.add((Component)this.jScrollPane2, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.contentPanel.add((Component)this.descPanel, gridBagConstraints);
        this.btPanel.setLayout(new GridBagLayout());
        this.modBtPanel.setLayout(new GridBagLayout());
        this.btMod.setText("Modifier");
        this.btMod.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AgendaModEventDay.this.btModActionPerformed(evt);
            }
        });
        this.modBtPanel.add((Component)this.btMod, new GridBagConstraints());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.btPanel.add((Component)this.modBtPanel, gridBagConstraints);
        this.cancelBtPanel.setLayout(new GridBagLayout());
        this.btCancel.setText("Annuler");
        this.btCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AgendaModEventDay.this.btCancelActionPerformed(evt);
            }
        });
        this.cancelBtPanel.add((Component)this.btCancel, new GridBagConstraints());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.btPanel.add((Component)this.cancelBtPanel, gridBagConstraints);
        this.deleteBtPanel.setBorder(BorderFactory.createTitledBorder("Supprimer"));
        this.deleteBtPanel.setLayout(new GridBagLayout());
        this.ckAllUsers.setText("Pour tout le monde");
        this.deleteBtPanel.add((Component)this.ckAllUsers, new GridBagConstraints());
        this.ckAllDays.setText("Pour tous les jours");
        this.deleteBtPanel.add((Component)this.ckAllDays, new GridBagConstraints());
        this.btDelete.setText("Supprimer");
        this.btDelete.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AgendaModEventDay.this.btDeleteActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.weightx = 1.0;
        this.deleteBtPanel.add((Component)this.btDelete, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.btPanel.add((Component)this.deleteBtPanel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.contentPanel.add((Component)this.btPanel, gridBagConstraints);
        this.add((Component)this.contentPanel, "Center");
    }

    private void btDeleteActionPerformed(ActionEvent evt) {
        if (JOptionPane.showConfirmDialog(this, "\u00cates-vous sur de vouloir supprimer cet \u00e9v\u00e8nement ?", "Suppression", 2) == 0) {
            Integer eventId = null;
            Integer empId = null;
            if (this.ckAllDays.isSelected()) {
                eventId = this.event.getEbEvents().getIdebEvent();
                empId = this.event.getEmployees().getId();
            }
            if (this.ckAllUsers.isSelected()) {
                empId = null;
            }
            EventUtil.deleteRelEventEmpDate(this.event.getIdebRelEventEmpDate(), eventId, empId);
            this.parent.dispose();
            EventUtil.gettApp().reload();
        }
        this.parent.setAlwaysOnTop(true);
    }

    private void ckModDateActionPerformed(ActionEvent evt) {
        this.startTimeBean.setDateEnabled(this.ckModDate.isSelected());
        this.endTimeBean.setDateEnabled(this.ckModDate.isSelected());
    }

    private void btModActionPerformed(ActionEvent evt) {
        EventUtil.modRelempeventdate(this.event, null, this.startTimeBean.getDateTime(), this.endTimeBean.getDateTime(), this.event.getEmployees().getId(), this.txtTitle.getText(), this.txtGeneralDesc.getText(), this.txtTaskDesc.getText(), this.getEmployees(), (EbCli)this.jCBoxCli.getSelectedItem(), !this.ckChgDH.isSelected(), this.ckModDate.isSelected());
        this.parent.dispose();
        EventUtil.gettApp().reload();
    }

    private void btCancelActionPerformed(ActionEvent evt) {
        this.parent.dispose();
    }

    private void ckChgDHActionPerformed(ActionEvent evt) {
        this.datesPanel.setEnabled(this.ckChgDH.isSelected());
        this.debutPanel.setEnabled(this.ckChgDH.isSelected());
        this.finPanel.setEnabled(this.ckChgDH.isSelected());
        this.ckModDate.setEnabled(this.ckChgDH.isSelected());
        this.ckAllUsersDate.setEnabled(this.ckChgDH.isSelected());
        this.startTimeBean.setEnabled(this.ckChgDH.isSelected());
        this.endTimeBean.setEnabled(this.ckChgDH.isSelected());
    }
}

