/*
 * Decompiled with CFR 0.152.
 */
package beans;

import beans.AgendaUser;
import beans.AgendaWeek;
import business.EventUtil;
import com.toedter.calendar.JCalendar;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.Locale;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import tables.EbEvents;

public class AgendaPanel
extends JPanel {
    private JLabel title;
    private List<AgendaWeek> weekList;
    private List<AgendaUser> userList;
    private List<AgendaUser> oldList;
    private JCalendar jcalendar;
    private Calendar startCalendar;
    private Calendar endCalendar;
    private Calendar newStart;
    private Calendar newEnd;

    public AgendaPanel() {
        this.setSize(800, 480);
        this.startCalendar = Calendar.getInstance(Locale.FRANCE);
        this.endCalendar = Calendar.getInstance(Locale.FRANCE);
        this.initComponents();
    }

    public AgendaPanel(Calendar startCalendar, Calendar endCalendar, List<AgendaUser> userList) {
        this.userList = userList;
        this.oldList = new ArrayList<AgendaUser>();
        this.oldList.addAll(userList);
        this.setSize(800, 480);
        this.startCalendar = Calendar.getInstance(Locale.FRANCE);
        this.endCalendar = endCalendar;
        this.startCalendar.setTime(startCalendar.getTime());
        System.out.println(startCalendar.getTime());
        this.setLayout(new BoxLayout(this, 3));
        this.initComponents();
    }

    public void ReloadAgendaPanel(Calendar startCalendar, Calendar endCalendar) {
        int currentDay = (startCalendar.get(7) - 2) % 7;
        int lastCurrentDay = (endCalendar.get(7) - 2) % 7;
        this.newStart = Calendar.getInstance(Locale.FRANCE);
        this.newEnd = Calendar.getInstance(Locale.FRANCE);
        this.newStart.setTime(startCalendar.getTime());
        this.newEnd.setTime(endCalendar.getTime());
        this.newStart.add(6, -currentDay);
        this.newEnd.add(6, 6 - lastCurrentDay);
        if (this.startCalendar.get(5) == startCalendar.get(5) && this.startCalendar.get(2) == startCalendar.get(2) && this.startCalendar.get(1) == startCalendar.get(1) && this.endCalendar.get(5) == endCalendar.get(5) && this.endCalendar.get(2) == endCalendar.get(2) && this.endCalendar.get(1) == endCalendar.get(1) && this.oldList.equals(this.userList)) {
            List<EbEvents> rs = EventUtil.fetchEventFromTo(this.newStart, this.newEnd);
            for (Component comp : this.getComponents()) {
                if (!(comp instanceof AgendaWeek)) continue;
                AgendaWeek week = (AgendaWeek)comp;
                week.reloadWeek(rs);
            }
        } else {
            this.oldList = new ArrayList<AgendaUser>();
            this.oldList.addAll(this.userList);
            this.setSize(800, 480);
            this.startCalendar = Calendar.getInstance(Locale.FRANCE);
            this.endCalendar = endCalendar;
            this.startCalendar.setTime(startCalendar.getTime());
            this.setLayout(new BoxLayout(this, 3));
            this.initComponents();
        }
    }

    private void initComponents() {
        this.removeAll();
        this.title = new JLabel("EuroBrevets Agenda");
        this.add(this.title);
        this.add(new JSeparator());
        int nbWeeks = 4;
        int nbYears = 1;
        if (this.endCalendar != null) {
            nbWeeks = this.endCalendar.get(3) - this.startCalendar.get(3);
            ++nbWeeks;
            nbYears = this.endCalendar.get(1) - this.startCalendar.get(1);
            if (nbYears > 0) {
                nbWeeks = nbYears * 52 + nbWeeks;
            }
        }
        int currentDay = (this.startCalendar.get(7) - 2) % 7;
        int lastCurrentDay = (this.endCalendar.get(7) - 2) % 7;
        System.out.println("from: " + currentDay + " to: " + lastCurrentDay);
        this.newStart = Calendar.getInstance(Locale.FRANCE);
        this.newEnd = Calendar.getInstance(Locale.FRANCE);
        this.newStart.setTime(this.startCalendar.getTime());
        this.newEnd.setTime(this.endCalendar.getTime());
        System.out.println(this.newStart.getTime() + " to " + this.newEnd.getTime());
        this.newStart.add(6, -currentDay);
        this.newEnd.add(6, 6 - lastCurrentDay);
        System.out.println(this.newStart.getTime() + " to " + this.newEnd.getTime());
        List<EbEvents> rs = EventUtil.fetchEventFromTo(this.newStart, this.newEnd);
        for (int i = 0; i < nbWeeks; ++i) {
            this.add(new AgendaWeek(this, this.newStart, rs, this.userList));
            this.newStart.add(3, 1);
            this.add(new JSeparator());
        }
        this.revalidate();
    }
}

