/*
 * Decompiled with CFR 0.152.
 */
package business;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import org.hibernate.Criteria;
import org.hibernate.SQLQuery;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.LogicalExpression;
import org.hibernate.criterion.Restrictions;
import tables.EbCli;
import tables.EbEvents;
import tables.EbReleventempdate;
import tables.EbWorktimetable;
import tables.Employees;
import ui.TestApplet;
import util.HibernateUtil;

public class EventUtil {
    private static Session session;
    private static Transaction transaction;
    private static TestApplet tApp;

    public static void openSession() {
        if (session != null && session.isOpen()) {
            session.close();
        }
        session = HibernateUtil.getSessionFactory().openSession();
    }

    public static List<EbEvents> fetchEventFromTo(Calendar fromCal, Calendar toCal) {
        transaction = session.beginTransaction();
        Date from = fromCal.getTime();
        Date to = toCal.getTime();
        LogicalExpression betweenDate = Restrictions.and((Criterion)Restrictions.le((String)"ebEventsStartDate", (Object)to), (Criterion)Restrictions.ge((String)"ebEventsEndDate", (Object)from));
        Criteria criteria = session.createCriteria(EbEvents.class);
        criteria.add((Criterion)betweenDate);
        List rs = criteria.list();
        transaction.commit();
        return rs;
    }

    public static List<EbCli> getClients() {
        return session.createCriteria(EbCli.class).list();
    }

    public static TestApplet gettApp() {
        return tApp;
    }

    public static void settApp(TestApplet tApp) {
        EventUtil.tApp = tApp;
    }

    public static List<EbReleventempdate> getEventUser(int eventId, int employeeId) {
        session.beginTransaction();
        String query = "Select * from ebjava.eb_releventempdate as a where a.eb_relEventEmpDateEventId =" + eventId + " AND a.eb_relEventEmpDateEmployee =" + employeeId;
        SQLQuery myQuery = session.createSQLQuery(query).addEntity(EbReleventempdate.class);
        session.getTransaction().commit();
        return myQuery.list();
    }

    public static EbReleventempdate getEventUser(int eventEmpId) {
        session.beginTransaction();
        String query = "Select * from ebjava.eb_releventempdate as a where a.ideb_relEventEmpDate =" + eventEmpId;
        SQLQuery myQuery = session.createSQLQuery(query).addEntity(EbReleventempdate.class);
        session.getTransaction().commit();
        return (EbReleventempdate)myQuery.uniqueResult();
    }

    public static List<Employees> getOtherParticipants(int eventId, Date date) {
        session.beginTransaction();
        String query = "Select * from ebjava.eb_releventempdate as a JOIN ebjava.employees as e on a.eb_relEventEmpDateEmployee=e.id where a.eb_relEventEmpDateEventId = " + eventId + " AND a.eb_relEventEmpDateDate = '" + date + "'";
        SQLQuery myQuery = session.createSQLQuery(query).addEntity(Employees.class);
        session.getTransaction().commit();
        return myQuery.list();
    }

    public static EbEvents addEvent(String eventName, String eventDesc, Calendar eventDate, Calendar endDate, int idCli, Employees[] participants, boolean isFullDay) {
        int cpt = 0;
        EbEvents newEvent = new EbEvents(eventDate.getTime(), idCli);
        if (endDate != null) {
            newEvent.setEbEventsEndDate(endDate.getTime());
        }
        if (eventName != null) {
            newEvent.setEbEventsName(eventName);
        }
        if (eventDesc != null) {
            newEvent.setEbEventsDesc(eventDesc);
        }
        session.beginTransaction();
        session.saveOrUpdate((Object)newEvent);
        session.getTransaction().commit();
        for (Employees currentEmployee : participants) {
            Calendar startTime = Calendar.getInstance(Locale.FRANCE);
            startTime.setTimeInMillis(eventDate.getTimeInMillis());
            Calendar endTime = Calendar.getInstance(Locale.FRANCE);
            endTime.setTime(endDate.getTime());
            endTime.set(6, startTime.get(6));
            while (startTime.before(endDate)) {
                EventUtil.addRelempeventdate(newEvent, currentEmployee, startTime, endTime, eventDesc, isFullDay);
                startTime.add(6, 1);
                endTime.add(6, 1);
                ++cpt;
            }
        }
        System.out.println(cpt + "rows inserted");
        return newEvent;
    }

    public static EbWorktimetable getWorkTime(int emp, Calendar date) {
        EbWorktimetable wtt = null;
        Calendar dateOfWork = Calendar.getInstance(Locale.FRANCE);
        dateOfWork.setTime(date.getTime());
        dateOfWork.set(11, 0);
        dateOfWork.set(12, 0);
        dateOfWork.set(13, 0);
        Criteria criteria = session.createCriteria(EbWorktimetable.class);
        criteria.add((Criterion)Restrictions.eq((String)"ebWorkTimeTableEmp", (Object)emp));
        criteria.add((Criterion)Restrictions.eq((String)"ebWorkTimeTableDate", (Object)dateOfWork.getTime()));
        try {
            wtt = (EbWorktimetable)criteria.uniqueResult();
        }
        catch (Exception e) {
            // empty catch block
        }
        return wtt;
    }

    public static List<EbWorktimetable> getWorkTimeList(int emp, Calendar dateStart, Calendar dateEnd) {
        Object wtt = null;
        Calendar dateOfWork = Calendar.getInstance(Locale.FRANCE);
        Calendar dateOfWorkEnd = Calendar.getInstance(Locale.FRANCE);
        dateOfWork.setTime(dateStart.getTime());
        dateOfWorkEnd.setTime(dateEnd.getTime());
        dateOfWork.set(11, 0);
        dateOfWork.set(12, 0);
        dateOfWork.set(13, 0);
        Criteria criteria = session.createCriteria(EbWorktimetable.class);
        criteria.add((Criterion)Restrictions.eq((String)"ebWorkTimeTableEmp", (Object)emp));
        criteria.add(Restrictions.between((String)"ebWorkTimeTableDate", (Object)dateOfWork.getTime(), (Object)dateOfWorkEnd.getTime()));
        return criteria.list();
    }

    public static Employees getEmployee(int id) {
        Criteria criteria = session.createCriteria(Employees.class);
        criteria.add((Criterion)Restrictions.eq((String)"id", (Object)id));
        Employees emp = null;
        try {
            emp = (Employees)criteria.uniqueResult();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return emp;
    }

    public static EbWorktimetable addWorkTime(int emp, Calendar date, int hour, int minute) {
        EbWorktimetable wtt = new EbWorktimetable();
        wtt.setEbWorkTimeTableEmp(emp);
        wtt.setEbWorkTimeTableDate(date.getTime());
        wtt.setEbWorkTimeTableNbHours(hour);
        wtt.setEbWorkTimeTableNbMin(minute);
        session.beginTransaction();
        session.saveOrUpdate((Object)wtt);
        session.getTransaction().commit();
        return wtt;
    }

    public static int addRelempeventdate(EbEvents event, Employees employee, Calendar start, Calendar end, String desc, boolean isFullDay) {
        EbReleventempdate eventEmpDate = new EbReleventempdate();
        eventEmpDate.setEbEvents(event);
        eventEmpDate.setEmployees(employee);
        eventEmpDate.setEbRelEventEmpDateStart(start.getTime());
        eventEmpDate.setEbRelEventEmpDateEnd(end.getTime());
        eventEmpDate.setEbRelEventEmpDateJobDesc(desc);
        eventEmpDate.setEbRelEventEmpDateDate(start.getTime());
        eventEmpDate.setEbRelEventEmpDateFullDay(isFullDay);
        session.beginTransaction();
        session.saveOrUpdate((Object)eventEmpDate);
        session.getTransaction().commit();
        return eventEmpDate.getIdebRelEventEmpDate();
    }

    public static void modRelempeventdate(EbReleventempdate eventEmp, Integer eventId, Calendar start, Calendar end, Integer empId, String eventName, String eventDesc, String jobDesc, Employees[] empList, EbCli client, boolean fullDay, boolean globalMod) {
        EbReleventempdate relEvent = eventEmp;
        EbEvents events = relEvent.getEbEvents();
        System.out.println(events.getEbEventsName());
        if (globalMod) {
            events.setEbEventsStartDate(start.getTime());
            int cpt = 0;
            for (Employees currentEmployee : empList) {
                List<EbReleventempdate> list = EventUtil.getEventUser(events.getIdebEvent(), currentEmployee.getId());
                Calendar startTime = Calendar.getInstance(Locale.FRANCE);
                startTime.setTimeInMillis(start.getTimeInMillis());
                Calendar endTime = Calendar.getInstance(Locale.FRANCE);
                endTime.setTime(end.getTime());
                endTime.set(6, startTime.get(6));
                startTime.set(11, 0);
                startTime.set(12, 0);
                startTime.set(13, 0);
                while (startTime.before(end)) {
                    EbReleventempdate event = null;
                    Criteria criteria = session.createCriteria(EbReleventempdate.class);
                    criteria.add((Criterion)Restrictions.eq((String)"employees", (Object)currentEmployee));
                    criteria.add((Criterion)Restrictions.eq((String)"ebEvents", (Object)events));
                    criteria.add((Criterion)Restrictions.eq((String)"ebRelEventEmpDateDate", (Object)startTime.getTime()));
                    try {
                        event = (EbReleventempdate)criteria.uniqueResult();
                    }
                    catch (Exception e) {
                        System.err.println(e.getMessage());
                    }
                    if (event == null) {
                        EventUtil.addRelempeventdate(events, currentEmployee, startTime, endTime, eventDesc, fullDay);
                        ++cpt;
                    }
                    startTime.add(6, 1);
                    endTime.add(6, 1);
                }
            }
            System.out.println(cpt);
        }
        relEvent.setEbRelEventEmpDateStart(start.getTime());
        relEvent.setEbRelEventEmpDateEnd(end.getTime());
        relEvent.setEbRelEventEmpDateJobDesc(jobDesc);
        relEvent.setEbRelEventEmpDateFullDay(fullDay);
        events.setEbEventsIdCli(client.getIdebCli());
        events.setEbEventsName(eventName);
        events.setEbEventsDesc(eventDesc);
        session.beginTransaction();
        session.update((Object)relEvent);
        session.update((Object)events);
        session.getTransaction().commit();
    }

    public static void deleteRelEventEmpDate(Integer relEventId, Integer eventId, Integer empId) {
        String query = "DELETE FROM eb_releventempdate WHERE ideb_relEventEmpDate=" + relEventId;
        if (empId != null) {
            query = "DELETE FROM eb_releventempdate WHERE eb_relEventEmpDateEmployee = " + empId + " AND eb_relEventEmpDateEventId = " + eventId;
        } else if (eventId != null) {
            query = "DELETE FROM eb_releventempdate WHERE eb_relEventEmpDateEventId= " + eventId;
        }
        session.beginTransaction();
        SQLQuery myQuery = session.createSQLQuery(query);
        myQuery.executeUpdate();
        EventUtil.deleteOrphanEvent();
        session.getTransaction().commit();
    }

    private static void deleteOrphanEvent() {
        String query = "DELETE FROM ebjava.eb_events WHERE ideb_event NOT IN (select b.eb_relEventEmpDateEventId from  ebjava.eb_releventempdate as b)";
        SQLQuery myQuery = session.createSQLQuery(query);
        try {
            myQuery.executeUpdate();
        }
        catch (Exception e) {
            System.err.println(e.getCause());
        }
    }

    public static List<EbEvents> preciseEventList(Calendar fromCale, Calendar toCale, List<EbEvents> list) {
        Calendar fromCal = Calendar.getInstance(Locale.FRANCE);
        Calendar toCal = Calendar.getInstance(Locale.FRANCE);
        fromCal.setTime(fromCale.getTime());
        toCal.setTime(toCale.getTime());
        fromCal.set(11, 0);
        fromCal.set(12, 0);
        fromCal.set(13, 0);
        toCal.set(11, 0);
        toCal.set(12, 0);
        toCal.set(13, 0);
        fromCal.add(12, -1);
        Date from = fromCal.getTime();
        Date to = toCal.getTime();
        ArrayList<EbEvents> preciseList = new ArrayList<EbEvents>();
        for (EbEvents ee : list) {
            if (!ee.getEbEventsStartDate().before(to) && !ee.getEbEventsStartDate().equals(to) || !ee.getEbEventsEndDate().after(from) && !ee.getEbEventsEndDate().equals(from)) continue;
            preciseList.add(ee);
        }
        return preciseList;
    }

    public static List<Employees> getEmployeeList() {
        session.beginTransaction();
        Criteria criteria = session.createCriteria(Employees.class);
        criteria.add((Criterion)Restrictions.eq((String)"disableEmpl", (Object)false));
        session.getTransaction().commit();
        return criteria.list();
    }
}

