/*
 * Decompiled with CFR 0.152.
 */
package ui;

import beans.AgendaPanel;
import beans.AgendaUser;
import business.EventUtil;
import com.toedter.calendar.JCalendar;
import com.toedter.calendar.JDateChooser;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.GraphicsEnvironment;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.ExecutionException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JApplet;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.SwingWorker;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import tables.Employees;
import ui.CreditView;

public class TestApplet
extends JApplet {
    private AgendaPanel agenda;
    private JCalendar jcalendar;
    private Calendar startCalendar;
    private Calendar endCalendar;
    private List<AgendaUser> userList;
    public static List<Employees> empList;
    public static HashMap<String, Employees> empMap;
    private ImageIcon image;
    private JButton btAllUser;
    private JButton btBuild;
    private JButton btCurWeek;
    private JButton btJCalEnd;
    private JButton btJCalStart;
    private JButton btNoUser;
    private JButton btResetWeek;
    private JPanel contentPanel;
    private JScrollPane contentScrollPane;
    private JPanel datePanel;
    private JDateChooser endDateChooser;
    private JPanel endDatePanel;
    private JMenu jMenu1;
    private JMenuBar jMenuBar1;
    private JMenuItem jMenuItem1;
    private JTextField labelEndDate;
    private JTextField labelStartDate;
    private JLabel lbDates;
    private JLabel lbEndDate;
    private JLabel lbStartDate;
    private JDateChooser startDateChooser;
    private JPanel startDatePanel;
    private JPanel topPanel;
    private JPanel userBtPanel;
    private JPanel userPanel;

    @Override
    public void init() {
        this.setSize(GraphicsEnvironment.getLocalGraphicsEnvironment().getMaximumWindowBounds().width - 16, GraphicsEnvironment.getLocalGraphicsEnvironment().getMaximumWindowBounds().height - 64);
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (ClassNotFoundException ex) {
            Logger.getLogger(TestApplet.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (InstantiationException ex) {
            Logger.getLogger(TestApplet.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IllegalAccessException ex) {
            Logger.getLogger(TestApplet.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (UnsupportedLookAndFeelException ex) {
            Logger.getLogger(TestApplet.class.getName()).log(Level.SEVERE, null, ex);
        }
        try {
            EventQueue.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    TestApplet.this.initComponents();
                    TestApplet.this.startDateChooser.setLocale(Locale.FRANCE);
                    TestApplet.this.endDateChooser.setLocale(Locale.FRANCE);
                    EventUtil.settApp(TestApplet.this);
                    EventUtil.openSession();
                    TestApplet.this.PopulateUsers();
                    TestApplet.this.reload();
                }
            });
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void reload() {
        final Calendar startTimeElapsed = Calendar.getInstance(Locale.FRANCE);
        SwingWorker<Object, Void> worker = new SwingWorker<Object, Void>(){
            JFrame loadFrame;

            @Override
            public Object doInBackground() {
                TestApplet.this.image = new ImageIcon("./resources/468.gif");
                this.loadFrame = new JFrame("Chargement...");
                this.loadFrame.setLayout(new BorderLayout());
                JLabel lbLoad = new JLabel("Chargement...");
                JLabel lbLoadImg = new JLabel();
                lbLoadImg.setIcon(TestApplet.this.image);
                this.loadFrame.add((Component)lbLoad, "Last");
                this.loadFrame.add((Component)lbLoadImg, "Center");
                this.loadFrame.setDefaultCloseOperation(2);
                this.loadFrame.setBounds(TestApplet.this.getBounds().x + TestApplet.this.getBounds().width / 2 - 35, TestApplet.this.getBounds().y + TestApplet.this.getBounds().height / 2 - 35, 10, 10);
                this.loadFrame.pack();
                this.loadFrame.setAlwaysOnTop(true);
                this.loadFrame.setVisible(true);
                this.loadFrame.revalidate();
                TestApplet.this.setEnabled(false);
                return new Object();
            }

            @Override
            public void done() {
                try {
                    Object object = this.get();
                    TestApplet.this.initAgenda();
                    this.loadFrame.dispose();
                    TestApplet.this.setEnabled(true);
                    Calendar timeElapsed = Calendar.getInstance(Locale.FRANCE);
                    long millisec = timeElapsed.getTimeInMillis() - startTimeElapsed.getTimeInMillis();
                    TestApplet.this.lbDates.setText("Dates - g\u00e9n\u00e9r\u00e9 en " + millisec + " ms");
                }
                catch (InterruptedException ignore) {
                }
                catch (ExecutionException e) {
                    String why = null;
                    Throwable cause = e.getCause();
                    why = cause != null ? cause.getMessage() : e.getMessage();
                    System.err.println("initagenda swingworker: " + e.getCause());
                    TestApplet.this.setEnabled(true);
                }
                catch (Exception e) {
                    System.err.println("initagenda swingworker exception " + e.getClass() + " " + e.getMessage() + " ");
                    for (StackTraceElement ste : e.getStackTrace()) {
                        System.out.println(ste);
                    }
                    TestApplet.this.setEnabled(true);
                }
            }
        };
        worker.execute();
    }

    private void initAgenda() {
        EventUtil.openSession();
        this.startCalendar = this.startDateChooser.getCalendar();
        this.endCalendar = this.endDateChooser.getCalendar();
        if (this.startCalendar == null) {
            this.startCalendar = Calendar.getInstance(Locale.FRANCE);
            this.startCalendar.add(3, -3);
        }
        this.startDateChooser.setCalendar(this.startCalendar);
        if (this.endCalendar == null) {
            this.endCalendar = Calendar.getInstance(Locale.FRANCE);
            this.endCalendar.add(3, 4);
        }
        this.endDateChooser.setCalendar(this.endCalendar);
        if (this.userList == null) {
            this.userList = new ArrayList<AgendaUser>();
        }
        this.checkUsers();
        int scrollProRata = this.endCalendar.get(3) - this.startCalendar.get(3);
        int scrollPos = Calendar.getInstance(Locale.FRANCE).get(3) - this.startCalendar.get(3);
        if (this.agenda == null) {
            this.agenda = new AgendaPanel(this.startCalendar, this.endCalendar, this.userList);
        } else {
            this.agenda.ReloadAgendaPanel(this.startCalendar, this.endCalendar);
        }
        this.contentScrollPane.setViewportView(this.agenda);
        int scrollValue = this.contentScrollPane.getVerticalScrollBar().getMaximum() / scrollProRata * scrollPos - (this.userList.size() * 56 + 8);
        this.contentScrollPane.getVerticalScrollBar().setValue(scrollValue);
        this.revalidate();
    }

    private void PopulateUsers() {
        if (empMap == null) {
            empMap = new HashMap();
        }
        empList = EventUtil.getEmployeeList();
        for (Employees emp : empList) {
            JCheckBox ckb = new JCheckBox();
            ckb.setText(emp.getInitiales());
            this.userPanel.add(ckb);
            empMap.put(emp.getInitiales(), emp);
        }
        this.revalidate();
    }

    private void checkUsers() {
        if (this.userList == null) {
            this.userList = new ArrayList<AgendaUser>();
        } else {
            this.userList.clear();
        }
        for (Component o : this.userPanel.getComponents()) {
            if (!(o instanceof JCheckBox)) continue;
            JCheckBox ckb = (JCheckBox)o;
            String initiales = ckb.getText();
            if (!ckb.isSelected() || !empMap.containsKey(initiales)) continue;
            Employees emp = empMap.get(initiales);
            this.userList.add(new AgendaUser(emp.getFullName(), emp.getInitiales(), emp.getFonction(), emp.getTelephone(), emp.getMail(), emp.getSkype(), emp.getId()));
        }
    }

    private void checkUserBoxes(boolean check) {
        for (Component o : this.userPanel.getComponents()) {
            if (!(o instanceof JCheckBox)) continue;
            JCheckBox ckb = (JCheckBox)o;
            ckb.setSelected(check);
        }
    }

    private void initComponents() {
        this.labelStartDate = new JTextField();
        this.btJCalStart = new JButton();
        this.labelEndDate = new JTextField();
        this.btJCalEnd = new JButton();
        this.topPanel = new JPanel();
        this.lbDates = new JLabel();
        this.btBuild = new JButton();
        this.datePanel = new JPanel();
        this.btCurWeek = new JButton();
        this.btResetWeek = new JButton();
        this.startDatePanel = new JPanel();
        this.lbStartDate = new JLabel();
        this.startDateChooser = new JDateChooser();
        this.endDatePanel = new JPanel();
        this.lbEndDate = new JLabel();
        this.endDateChooser = new JDateChooser();
        this.userPanel = new JPanel();
        this.userBtPanel = new JPanel();
        this.btAllUser = new JButton();
        this.btNoUser = new JButton();
        this.contentPanel = new JPanel();
        this.contentScrollPane = new JScrollPane();
        this.jMenuBar1 = new JMenuBar();
        this.jMenu1 = new JMenu();
        this.jMenuItem1 = new JMenuItem();
        this.labelStartDate.setColumns(8);
        this.btJCalStart.setIcon(new ImageIcon(this.getClass().getResource("/com/toedter/calendar/images/JCalendarColor16.gif")));
        this.btJCalStart.setMargin(new Insets(2, 2, 2, 2));
        this.btJCalStart.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TestApplet.this.btJCalStartActionPerformed(evt);
            }
        });
        this.labelEndDate.setColumns(8);
        this.btJCalEnd.setIcon(new ImageIcon(this.getClass().getResource("/com/toedter/calendar/images/JCalendarColor16.gif")));
        this.btJCalEnd.setMargin(new Insets(2, 2, 2, 2));
        this.btJCalEnd.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TestApplet.this.btJCalEndActionPerformed(evt);
            }
        });
        this.getContentPane().setLayout(new GridBagLayout());
        this.topPanel.setLayout(new GridBagLayout());
        this.lbDates.setText("Dates");
        this.lbDates.setOpaque(true);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        this.topPanel.add((Component)this.lbDates, gridBagConstraints);
        this.btBuild.setText("Charger");
        this.btBuild.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TestApplet.this.btBuildActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.weightx = 1.0;
        this.topPanel.add((Component)this.btBuild, gridBagConstraints);
        this.datePanel.setBorder(BorderFactory.createTitledBorder("Dates"));
        this.datePanel.setLayout(new BoxLayout(this.datePanel, 2));
        this.btCurWeek.setText("Cette semaine");
        this.btCurWeek.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TestApplet.this.btCurWeekActionPerformed(evt);
            }
        });
        this.datePanel.add(this.btCurWeek);
        this.btResetWeek.setText("Reset");
        this.btResetWeek.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TestApplet.this.btResetWeekActionPerformed(evt);
            }
        });
        this.datePanel.add(this.btResetWeek);
        this.lbStartDate.setText("from");
        this.startDatePanel.add(this.lbStartDate);
        this.startDatePanel.add((Component)this.startDateChooser);
        this.datePanel.add(this.startDatePanel);
        this.lbEndDate.setText("to");
        this.endDatePanel.add(this.lbEndDate);
        this.endDatePanel.add((Component)this.endDateChooser);
        this.datePanel.add(this.endDatePanel);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 23;
        gridBagConstraints.weightx = 1.0;
        this.topPanel.add((Component)this.datePanel, gridBagConstraints);
        this.userPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createTitledBorder("Users"), "Utilisateurs"));
        this.userPanel.setLayout(new BoxLayout(this.userPanel, 2));
        this.btAllUser.setText("Tous");
        this.btAllUser.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TestApplet.this.btAllUserActionPerformed(evt);
            }
        });
        this.userBtPanel.add(this.btAllUser);
        this.btNoUser.setText("Aucun");
        this.btNoUser.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TestApplet.this.btNoUserActionPerformed(evt);
            }
        });
        this.userBtPanel.add(this.btNoUser);
        this.userPanel.add(this.userBtPanel);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 26;
        gridBagConstraints.weightx = 1.0;
        this.topPanel.add((Component)this.userPanel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.getContentPane().add((Component)this.topPanel, gridBagConstraints);
        this.contentPanel.setBorder(BorderFactory.createTitledBorder("Agenda"));
        this.contentPanel.setLayout(new GridLayout(1, 7));
        this.contentPanel.add(this.contentScrollPane);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.getContentPane().add((Component)this.contentPanel, gridBagConstraints);
        this.jMenu1.setText("File");
        this.jMenuItem1.setText("jMenuItem1");
        this.jMenuItem1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TestApplet.this.jMenuItem1ActionPerformed(evt);
            }
        });
        this.jMenu1.add(this.jMenuItem1);
        this.jMenuBar1.add(this.jMenu1);
        this.setJMenuBar(this.jMenuBar1);
    }

    private void btBuildActionPerformed(ActionEvent evt) {
        this.reload();
    }

    private void btJCalEndActionPerformed(ActionEvent evt) {
        this.jcalendar = new JCalendar();
        if (JOptionPane.showOptionDialog(this.btJCalEnd, this.jcalendar, "Select a date", 2, 3, null, null, null) == 0) {
            this.labelEndDate.setText(this.jcalendar.getCalendar().get(5) + "-" + (this.jcalendar.getCalendar().get(2) + 1) + "-" + this.jcalendar.getCalendar().get(1));
            this.endCalendar = this.jcalendar.getCalendar();
        }
    }

    private void btJCalStartActionPerformed(ActionEvent evt) {
        this.jcalendar = new JCalendar();
        if (JOptionPane.showOptionDialog(this.btJCalStart, this.jcalendar, "Select a date", 2, 3, null, null, null) == 0) {
            this.labelStartDate.setText(this.jcalendar.getCalendar().get(5) + "-" + (this.jcalendar.getCalendar().get(2) + 1) + "-" + this.jcalendar.getCalendar().get(1));
            this.startCalendar = this.jcalendar.getCalendar();
        }
    }

    private void btAllUserActionPerformed(ActionEvent evt) {
        this.checkUserBoxes(true);
    }

    private void btNoUserActionPerformed(ActionEvent evt) {
        this.checkUserBoxes(false);
    }

    private void btCurWeekActionPerformed(ActionEvent evt) {
        this.startDateChooser.setCalendar(Calendar.getInstance(Locale.FRANCE));
    }

    private void btResetWeekActionPerformed(ActionEvent evt) {
        this.startDateChooser.setCalendar(null);
        this.endDateChooser.setCalendar(null);
    }

    private void jMenuItem1ActionPerformed(ActionEvent evt) {
        JFrame creditFrame = new JFrame("Heures");
        CreditView creditView = new CreditView();
        creditFrame.add(creditView);
        creditFrame.pack();
        creditFrame.setDefaultCloseOperation(2);
        creditFrame.setVisible(true);
    }
}

